---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 100200 Added unique constraint exception handling to pkg_ALKINDI_EVALUATION.sp_INSERT_Evals
-- MSW 100500 Removed WEB_EVALUATION Object
-- MSW 100500 Removed EVALUATIONS_array Varray
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_USER_DATA
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_ALKINDEX_DATA
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC1
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC2
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC1
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC2
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------


CREATE OR REPLACE PACKAGE pkg_ALKINDI_EVALUATION				-- BK092400
AS
  TYPE EVALUATION_cursor_type is REF CURSOR;

  PROCEDURE sp_INSERT_Evals(
     i_USER_ID				IN	EVALUATION.USER_ID%TYPE,
     i_PRODUCT_ID				IN	EVALUATION.PRODUCT_ID%TYPE,
     i_EVALUATION_SCALE_ID		IN	EVALUATION.EVALUATION_SCALE_ID%TYPE);

    PROCEDURE sp_SEL_Evals_by_User(
	i_USER_ID				IN	EVALUATION.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT	EVALUATION_cursor_type,
	o_ERROR_CODE			OUT	NUMBER);

  PROCEDURE sp_SEL_USER_DATA(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CALC_M1				OUT		USER_CLUSTER_MEAN_DISTANCE.CALC_M1%TYPE,
	o_CALC_M2				OUT		USER_CLUSTER_MEAN_DISTANCE.CALC_M2%TYPE,
	o_Ei					OUT		USER_PRODUCT_CLUSTER_STAT.FRACTION_OF_EVAL_SEEN%TYPE,
	o_Ri					OUT		USER_PRODUCT_CLUSTER_STAT.AVG_PROD_EVAL%TYPE,
	o_Fi					OUT		USER_PRODUCT_CLUSTER_STAT.FRACTION_OF_PC_EVAL%TYPE,
	o_Eave				OUT		USER_STAT.FRACTION_PROD_SEEN%TYPE,
	o_Rave				OUT		USER_STAT.AVG_PROD_EVAL%TYPE,
	o_Ni					OUT		PRODUCT_CLUSTER_STAT.TOTAL_PROD_IN_PC%TYPE,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	i_OMEGA				IN		PRODUCT_STAT.TOTAL_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	i_OMEGA				IN		PRODUCT_STAT.TOTAL_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);


END pkg_ALKINDI_EVALUATION;
/

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_EVALUATION				-- BK092400  - Timestamp Added
AS

  PROCEDURE sp_INSERT_Evals(
     i_USER_ID				IN	EVALUATION.USER_ID%TYPE,
     i_PRODUCT_ID				IN	EVALUATION.PRODUCT_ID%TYPE,
     i_EVALUATION_SCALE_ID		IN	EVALUATION.EVALUATION_SCALE_ID%TYPE)

   IS 
	ERR_NUM	NUMBER; 
	ERR_MSG 	VARCHAR2(255);
   BEGIN

	INSERT INTO EVALUATION(USER_ID, PRODUCT_ID, EVALUATION_SCALE_ID, EVALUATION_TIMESTAMP)
           VALUES (i_USER_ID,i_PRODUCT_ID,i_EVALUATION_SCALE_ID, sysdate);

   EXCEPTION
	WHEN DUP_VAL_ON_INDEX THEN
		UPDATE EVALUATION 
		   SET EVALUATION_SCALE_ID=i_EVALUATION_SCALE_ID
		     , EVALUATION_TIMESTAMP=sysdate
		 WHERE USER_ID = i_USER_ID
		   AND PRODUCT_ID = i_PRODUCT_ID;

	err_num := SQLCODE; 
	err_msg := SQLERRM;
	INSERT INTO errors
	VALUES (err_num, err_msg); 

 END sp_INSERT_Evals;

-- ==========================================================================================

  PROCEDURE sp_SEL_Evals_by_User(							-- MSW092500 - Corrected cursor
	i_USER_ID				IN	EVALUATION.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT	EVALUATION_cursor_type,
	o_ERROR_CODE			OUT	NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
   OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_ID
	     , EVALUATION_SCALE_ID
        FROM EVALUATION
       WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6553;
    CLOSE o_Evaluation_cursor_type;
 END sp_SEL_Evals_by_User;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_DATA(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CALC_M1				OUT		USER_CLUSTER_MEAN_DISTANCE.CALC_M1%TYPE,
	o_CALC_M2				OUT		USER_CLUSTER_MEAN_DISTANCE.CALC_M2%TYPE,
	o_Ei					OUT		USER_PRODUCT_CLUSTER_STAT.FRACTION_OF_EVAL_SEEN%TYPE,
	o_Ri					OUT		USER_PRODUCT_CLUSTER_STAT.AVG_PROD_EVAL%TYPE,
	o_Fi					OUT		USER_PRODUCT_CLUSTER_STAT.FRACTION_OF_PC_EVAL%TYPE,
	o_Eave				OUT		USER_STAT.FRACTION_PROD_SEEN%TYPE,
	o_Rave				OUT		USER_STAT.AVG_PROD_EVAL%TYPE,
	o_Ni					OUT		PRODUCT_CLUSTER_STAT.TOTAL_PROD_IN_PC%TYPE,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN 
	o_ERROR_CODE := 0; 

	SELECT CALC_M1, CALC_M2 INTO o_CALC_M1, o_CALC_M2
	  FROM USER_CLUSTER_MEAN_DISTANCE
	 WHERE USER_ID = i_USER_ID
	   AND USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	SELECT AVG_PROD_EVAL, FRACTION_OF_EVAL_SEEN, FRACTION_OF_PC_EVAL INTO o_Ri, o_Ei, o_Fi
	  FROM USER_PRODUCT_CLUSTER_STAT
	 WHERE USER_ID = i_USER_ID
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

	SELECT AVG_PROD_EVAL, FRACTION_PROD_SEEN INTO o_Rave, o_Eave
	  FROM USER_STAT
	 WHERE USER_ID = i_USER_ID;

	SELECT TOTAL_PROD_IN_PC INTO o_Ni
	  FROM PRODUCT_CLUSTER_STAT
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
  END sp_SEL_USER_DATA; 

-- ==========================================================================================

-- ==========================================================================================

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_STAT.PRODUCT_ID
	  FROM PRODUCT_STAT, REL_PRODUCT_CLUSTER
	 WHERE REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = PRODUCT_STAT.PRODUCT_ID
	   AND PRODUCT_STAT.NEW_ADDITION_IND = 1
	   AND (PRODUCT_STAT.TOTAL_USER_EVAL < i_Q
	    OR  PRODUCT_STAT.FRACTION_USER_SEEN > i_R);

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_NEW_PROD_DATA_BY_PC1;

-- ==========================================================================================

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_STAT.PRODUCT_ID
	  FROM PRODUCT_STAT, REL_PRODUCT_CLUSTER
	 WHERE REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = PRODUCT_STAT.PRODUCT_ID
	   AND PRODUCT_STAT.NEW_ADDITION_IND = 1
	   AND PRODUCT_STAT.TOTAL_USER_EVAL > i_Q
	   AND PRODUCT_STAT.FRACTION_USER_SEEN < i_R;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_NEW_PROD_DATA_BY_PC2;

-- ==========================================================================================

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_USER(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

SELECT PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID AS PRODUCT_CLUSTER_ID
, SUM(FRACTION_USER_SEEN) AS epi
, MIN(W_TOTAL_NEW_PROD_IN_PC) AS ni
, MIN(FRACTION_OF_NEW_EVAL_SEEN) AS ei
, MIN(TOTAL_NEW_PROD_IN_PC) AS mi
FROM PRODUCT_STAT, REL_PRODUCT_CLUSTER, PRODUCT_CLUSTER_STAT, USER_PRODUCT_CLUSTER_STAT
WHERE PRODUCT_STAT.PRODUCT_ID = REL_PRODUCT_CLUSTER.PRODUCT_ID
  AND PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID = REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID
  AND USER_PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID = PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID
  AND USER_PRODUCT_CLUSTER_STAT.USER_ID = i_USER_ID
  AND PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID IN
(SELECT PRODUCT_CLUSTER_ID
   FROM USER_PRODUCT_CLUSTER_STAT
  WHERE USER_ID = i_USER_ID)
GROUP BY PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID;

  EXCEPTION
	WHEN OTHERS THEN
    o_ERROR_CODE  := -1;
    CLOSE o_EVALUATION_cursor_type;
END sp_SEL_NEW_PROD_DATA_BY_USER;

-- ==========================================================================================

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	i_OMEGA				IN		PRODUCT_STAT.TOTAL_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_STAT.PRODUCT_ID
	  FROM PRODUCT_STAT, REL_PRODUCT_CLUSTER
	 WHERE REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = PRODUCT_STAT.PRODUCT_ID
	   AND PRODUCT_STAT.NEW_ADDITION_IND = 0
	   AND TOTAL_USER_SEEN < i_OMEGA
	   AND (PRODUCT_STAT.TOTAL_USER_EVAL < i_Q
	    OR  PRODUCT_STAT.FRACTION_USER_SEEN > i_R);

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_OLD_PROD_DATA_BY_PC1;

-- ==========================================================================================

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PRODUCT_STAT.FRACTION_USER_SEEN%TYPE,
	i_Q					IN		PRODUCT_STAT.TOTAL_USER_EVAL%TYPE,
	i_OMEGA				IN		PRODUCT_STAT.TOTAL_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_STAT.PRODUCT_ID
	  FROM PRODUCT_STAT, REL_PRODUCT_CLUSTER
	 WHERE REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = PRODUCT_STAT.PRODUCT_ID
	   AND PRODUCT_STAT.NEW_ADDITION_IND = 0
	   AND TOTAL_USER_SEEN < i_OMEGA
	   AND PRODUCT_STAT.TOTAL_USER_EVAL > i_Q
	   AND PRODUCT_STAT.FRACTION_USER_SEEN < i_R;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_OLD_PROD_DATA_BY_PC2;


END pkg_ALKINDI_EVALUATION;
/

SHOW ERRORS
